<?php

/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package reland
 */


/**
 *
 * Reland Header
 */

function reland_check_header()
{
    $reland_header_style = function_exists('get_field') ? get_field('header_style') : NULL;
    $reland_default_header_style = get_theme_mod('choose_default_header', 'header-style-1');

    if ($reland_header_style == 'header-style-1' && empty($_GET['s'])) {
        get_template_part('template-parts/header/header-1');
    } elseif ($reland_header_style == 'header-style-2' && empty($_GET['s'])) {
        get_template_part('template-parts/header/header-2');
    } elseif ($reland_header_style == 'header-style-3' && empty($_GET['s'])) {
        get_template_part('template-parts/header/header-3');
    } elseif ($reland_header_style == 'header-style-4' && empty($_GET['s'])) {
        get_template_part('template-parts/header/header-4');
    } elseif ($reland_header_style == 'header-style-5' && empty($_GET['s'])) {
        get_template_part('template-parts/header/header-5');
    } elseif ($reland_header_style == 'header-style-6' && empty($_GET['s'])) {
        get_template_part('template-parts/header/header-6');
    } elseif ($reland_header_style == 'header-style-7' && empty($_GET['s'])) {
        get_template_part('template-parts/header/header-7');
    } elseif ($reland_header_style == 'header-style-8' && empty($_GET['s'])) {
        get_template_part('template-parts/header/header-8');
    } else {

        /** Default Header Style **/
        if ($reland_default_header_style == 'header-style-2') {
            get_template_part('template-parts/header/header-2');
        } elseif ($reland_default_header_style == 'header-style-3') {
            get_template_part('template-parts/header/header-3');
        } elseif ($reland_default_header_style == 'header-style-4') {
            get_template_part('template-parts/header/header-4');
        } elseif ($reland_default_header_style == 'header-style-5') {
            get_template_part('template-parts/header/header-5');
        } elseif ($reland_default_header_style == 'header-style-6') {
            get_template_part('template-parts/header/header-6');
        } elseif ($reland_default_header_style == 'header-style-7') {
            get_template_part('template-parts/header/header-7');
        } elseif ($reland_default_header_style == 'header-style-8') {
            get_template_part('template-parts/header/header-8');
        } else {
            get_template_part('template-parts/header/header-1');
        }
    }
}
add_action('reland_header_style', 'reland_check_header', 10);


/**
 * [reland_header_lang description]
 * @return [type] [description]
 */
function reland_header_lang_default()
{
    $reland_header_lang = get_theme_mod('reland_header_lang', false);
    if ($reland_header_lang) : ?>

        <ul>
            <li><a href="javascript:void(0)" class="lang__btn"><?php print esc_html__('English', 'reland'); ?> <i class="fa-light fa-angle-down"></i></a>
                <?php do_action('reland_language'); ?>
            </li>
        </ul>

    <?php endif; ?>
<?php
}

/**
 * [reland_language_list description]
 * @return [type] [description]
 */
function _reland_language($mar)
{
    return $mar;
}
function reland_language_list()
{

    $mar = '';
    $languages = apply_filters('wpml_active_languages', NULL, 'orderby=id&order=desc');
    if (!empty($languages)) {
        $mar = '<ul class="lang-list">';
        foreach ($languages as $lan) {
            $active = $lan['active'] == 1 ? 'active' : '';
            $mar .= '<li class="' . $active . '"><a href="' . $lan['url'] . '">' . $lan['translated_name'] . '</a></li>';
        }
        $mar .= '</ul>';
    } else {
        //remove this code when send themeforest reviewer team
        $mar .= '<ul class="lang-list">';
        $mar .= '<li><a href="#">' . esc_html__('IND', 'reland') . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__('SPA', 'reland') . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__('GRE', 'reland') . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__('CIN', 'reland') . '</a></li>';
        $mar .= ' </ul>';
    }
    print _reland_language($mar);
}
add_action('reland_language', 'reland_language_list');


// Header Logo
function reland_header_logo()
{ ?>
    <?php
    $reland_logo_on = function_exists('get_field') ? get_field('is_enable_sec_logo') : NULL;
    $reland_logo = get_template_directory_uri() . '/assets/img/logo/logo.png';
    $reland_logo_black = get_template_directory_uri() . '/assets/img/logo/secondary_logo.png';

    $reland_site_logo = get_theme_mod('logo', $reland_logo);
    $reland_secondary_logo = get_theme_mod('secondary_logo', $reland_logo_black);
    ?>

    <?php if (!empty($reland_logo_on)) : ?>
        <a class="secondary-logo" href="<?php print esc_url(home_url('/')); ?>">
            <img src="<?php print esc_url($reland_secondary_logo); ?>" height="auto" width="<?php echo get_theme_mod('logo_size_adjust', '111px'); ?>" alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" />
        </a>
    <?php else : ?>
        <a class="main-logo" href="<?php print esc_url(home_url('/')); ?>">
            <img src="<?php print esc_url($reland_site_logo); ?>" height="auto" width="<?php echo get_theme_mod('logo_size_adjust', '111px'); ?>" alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" />
        </a>
    <?php endif; ?>
<?php
}

// Header Sticky Logo
function reland_header_sticky_logo()
{ ?>
    <?php
    $reland_logo = get_template_directory_uri() . '/assets/img/logo/logo.png';
    $reland_site_logo = get_theme_mod('logo', $reland_logo);
    ?>
    <a class="sticky-logo" href="<?php print esc_url(home_url('/')); ?>">
        <img src="<?php print esc_url($reland_site_logo); ?>" height="auto" width="<?php echo get_theme_mod('logo_size_adjust', '111px'); ?>" alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" />
    </a>
<?php
}

// Mobile Menu Logo
function reland_mobile_logo()
{

    $mobile_menu_logo = get_template_directory_uri() . '/assets/img/logo/logo.png';
    $mobile_logo = get_theme_mod('mobile_logo', $mobile_menu_logo);

?>

    <a class="main-logo" href="<?php print esc_url(home_url('/')); ?>">
        <img src="<?php print esc_url($mobile_logo); ?>" height="auto" width="<?php echo get_theme_mod('logo_size_adjust', '111px'); ?>" alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" />
    </a>

<?php }


/**
 * [reland_header_social_profiles description]
 * @return [type] [description]
 */
function reland_header_social_profiles()
{
    $reland_header_fb_url = get_theme_mod('reland_header_fb_url', __('#', 'reland'));
    $reland_header_twitter_url = get_theme_mod('reland_header_twitter_url', __('#', 'reland'));
    $reland_header_linkedin_url = get_theme_mod('reland_header_linkedin_url', __('#', 'reland'));
?>
    <ul>
        <?php if (!empty($reland_header_fb_url)) : ?>
            <li><a href="<?php print esc_url($reland_header_fb_url); ?>"><span><i class="flaticon-facebook"></i></span></a></li>
        <?php endif; ?>

        <?php if (!empty($reland_header_twitter_url)) : ?>
            <li><a href="<?php print esc_url($reland_header_twitter_url); ?>"><span><i class="flaticon-twitter"></i></span></a></li>
        <?php endif; ?>

        <?php if (!empty($reland_header_linkedin_url)) : ?>
            <li><a href="<?php print esc_url($reland_header_linkedin_url); ?>"><span><i class="flaticon-linkedin"></i></span></a></li>
        <?php endif; ?>
    </ul>

<?php
}

function reland_footer_social_profiles()
{
    $reland_footer_fb_url = get_theme_mod('reland_footer_fb_url', __('#', 'reland'));
    $reland_footer_twitter_url = get_theme_mod('reland_footer_twitter_url', __('#', 'reland'));
    $reland_footer_vimeo_url = get_theme_mod('reland_footer_vimeo_url', __('#', 'reland'));
    $reland_footer_youtube_url = get_theme_mod('reland_footer_youtube_url', __('#', 'reland'));
?>

    <ul>
        <?php if (!empty($reland_footer_fb_url)) : ?>
            <li>
                <a href="<?php print esc_url($reland_footer_fb_url); ?>">
                    <i class="fab fa-facebook-square"></i>
                </a>
            </li>
        <?php endif; ?>

        <?php if (!empty($reland_footer_twitter_url)) : ?>
            <li>
                <a href="<?php print esc_url($reland_footer_twitter_url); ?>">
                    <i class="fab fa-twitter"></i>
                </a>
            </li>
        <?php endif; ?>

        <?php if (!empty($reland_footer_vimeo_url)) : ?>
            <li>
                <a href="<?php print esc_url($reland_footer_vimeo_url); ?>">
                    <i class="fab fa-vimeo-v"></i>
                </a>
            </li>
        <?php endif; ?>

        <?php if (!empty($reland_footer_youtube_url)) : ?>
            <li>
                <a href="<?php print esc_url($reland_footer_youtube_url); ?>">
                    <i class="fab fa-youtube"></i>
                </a>
            </li>
        <?php endif; ?>
    </ul>
<?php
}

/**
 * [reland_mobile_social_profiles description]
 * @return [type] [description]
 */
function reland_mobile_social_profiles()
{
    $reland_mobile_fb_url           = get_theme_mod('reland_mobile_fb_url', __('#', 'reland'));
    $reland_mobile_twitter_url      = get_theme_mod('reland_mobile_twitter_url', __('#', 'reland'));
    $reland_mobile_instagram_url    = get_theme_mod('reland_mobile_instagram_url', __('#', 'reland'));
    $reland_mobile_linkedin_url     = get_theme_mod('reland_mobile_linkedin_url', __('#', 'reland'));
    $reland_mobile_telegram_url      = get_theme_mod('reland_mobile_telegram_url', __('#', 'reland'));
?>

    <ul class="clearfix">
        <?php if (!empty($reland_mobile_fb_url)) : ?>
            <li class="facebook">
                <a href="<?php print esc_url($reland_mobile_fb_url); ?>"><i class="fab fa-facebook-f"></i></a>
            </li>
        <?php endif; ?>

        <?php if (!empty($reland_mobile_twitter_url)) : ?>
            <li class="twitter">
                <a href="<?php print esc_url($reland_mobile_twitter_url); ?>">
                    <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M8.33192 5.92804L13.5438 0H12.3087L7.78328 5.14724L4.16883 0H0L5.46575 7.78353L0 14H1.2351L6.01407 8.56431L9.83119 14H14L8.33192 5.92804ZM6.64027 7.85211L6.08648 7.07704L1.68013 0.909771H3.57718L7.13316 5.88696L7.68694 6.66202L12.3093 13.1316H10.4123L6.64027 7.85211Z" fill="currentColor" />
                    </svg>
                </a>
            </li>
        <?php endif; ?>

        <?php if (!empty($reland_mobile_instagram_url)) : ?>
            <li class="instagram">
                <a href="<?php print esc_url($reland_mobile_instagram_url); ?>"><i class="fab fa-instagram"></i></a>
            </li>
        <?php endif; ?>

        <?php if (!empty($reland_mobile_linkedin_url)) : ?>
            <li class="linkedin">
                <a href="<?php print esc_url($reland_mobile_linkedin_url); ?>"><i class="fab fa-linkedin-in"></i></a>
            </li>
        <?php endif; ?>

        <?php if (!empty($reland_mobile_telegram_url)) : ?>
            <li class="telegram">
                <a href="<?php print esc_url($reland_mobile_telegram_url); ?>"><i class="fab fa-telegram-plane"></i></a>
            </li>
        <?php endif; ?>
    </ul>

<?php
}


/**
 * [reland_header_menu description]
 * @return [type] [description]
 */
function reland_header_menu()
{
?>
    <?php
    wp_nav_menu([
        'theme_location' => 'main-menu',
        'menu_class'     => 'navigation',
        'container'      => '',
        'fallback_cb'    => 'Reland_Navwalker_Class::fallback',
        'walker'         => new Reland_Navwalker_Class,
    ]);
    ?>
<?php
}


/**
 * [reland_hamburger_menu description]
 * @return [type] [description]
 */
function reland_hamburger_menu()
{
?>
    <?php
    wp_nav_menu([
        'theme_location' => 'hamburger-menu',
        'menu_class'     => 'navigation',
        'container'      => '',
        'fallback_cb'    => 'Reland_Navwalker_Class::fallback',
        'walker'         => new Reland_Navwalker_Class,
    ]);
    ?>
<?php
}

/**
 * [reland_header_menu description]
 * @return [type] [description]
 */
function reland_mobile_menu()
{
?>
    <?php
    $reland_menu = wp_nav_menu([
        'theme_location' => 'main-menu',
        'menu_class'     => 'navigation',
        'container'      => '',
        'fallback_cb'    => false,
        'echo'           => false,
    ]);

    $reland_menu = str_replace("menu-item-has-children", "menu-item-has-children has-children", $reland_menu);
    echo wp_kses_post($reland_menu);
    ?>
<?php
}

/**
 * [reland_blog_mobile_menu description]
 * @return [type] [description]
 */
function reland_blog_mobile_menu()
{
?>
    <?php
    $reland_menu = wp_nav_menu([
        'theme_location' => 'blog-menu',
        'menu_class'     => 'navigation',
        'container'      => '',
        'fallback_cb'    => false,
        'echo'           => false,
    ]);

    $reland_menu = str_replace("menu-item-has-children", "menu-item-has-children has-children", $reland_menu);
    echo wp_kses_post($reland_menu);
    ?>
<?php
}

/**
 * [reland_search_menu description]
 * @return [type] [description]
 */
function reland_header_search_menu()
{
?>
    <?php
    wp_nav_menu([
        'theme_location' => 'header-search-menu',
        'menu_class'     => '',
        'container'      => '',
        'fallback_cb'    => 'Reland_Navwalker_Class::fallback',
        'walker'         => new Reland_Navwalker_Class,
    ]);
    ?>
<?php
}

/**
 * [reland_footer_menu description]
 * @return [type] [description]
 */
function reland_footer_menu()
{
    wp_nav_menu([
        'theme_location' => 'footer-menu',
        'menu_class'     => 'navigation',
        'container'      => '',
        'fallback_cb'    => 'Reland_Navwalker_Class::fallback',
        'walker'         => new Reland_Navwalker_Class,
    ]);
}


/**
 * [reland_category_menu description]
 * @return [type] [description]
 */
function reland_category_menu()
{
    wp_nav_menu([
        'theme_location' => 'category-menu',
        'menu_class'     => 'cat-submenu m-0',
        'container'      => '',
        'fallback_cb'    => 'Reland_Navwalker_Class::fallback',
        'walker'         => new Reland_Navwalker_Class,
    ]);
}

/**
 *
 * reland footer
 */
add_action('reland_footer_style', 'reland_check_footer', 10);

function reland_check_footer()
{

    $footer_show = 1;
    $is_footer = function_exists('get_field') ? get_field('is_it_invisible_footer') : '';
    if (!empty($_GET['s'])) {
        $is_footer = null;
    }

    if (empty($is_footer) && $footer_show == 1) {
        $reland_footer_style = function_exists('get_field') ? get_field('footer_style') : NULL;
        $reland_default_footer_style = get_theme_mod('choose_default_footer', 'footer-style-1');

        get_template_part('template-parts/footer/footer-1');
    }
}


// reland_copyright_text
function reland_copyright_text()
{
    print get_theme_mod('reland_copyright', wp_kses_post('Copyright © <span>Reland</span> 2024. All Rights Reserved', 'reland'));
}


/**
 *
 * pagination
 */
if (!function_exists('reland_pagination')) {

    function _reland_pagi_callback($pagination)
    {
        return $pagination;
    }

    //page navegation
    function reland_pagination($prev, $next, $pages, $args)
    {
        global $wp_query, $wp_rewrite;
        $menu = '';
        $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;

        if ($pages == '') {
            global $wp_query;
            $pages = $wp_query->max_num_pages;

            if (!$pages) {
                $pages = 1;
            }
        }

        $pagination = [
            'base'      => add_query_arg('paged', '%#%'),
            'format'    => '',
            'total'     => $pages,
            'current'   => $current,
            'prev_text' => $prev,
            'next_text' => $next,
            'type'      => 'array',
        ];

        //rewrite permalinks
        if ($wp_rewrite->using_permalinks()) {
            $pagination['base'] = user_trailingslashit(trailingslashit(remove_query_arg('s', get_pagenum_link(1))) . 'page/%#%/', 'paged');
        }

        if (!empty($wp_query->query_vars['s'])) {
            $pagination['add_args'] = ['s' => get_query_var('s')];
        }

        $pagi = '';
        if (paginate_links($pagination) != '') {
            $paginations = paginate_links($pagination);
            $pagi .= '<ul class="pagination">';
            foreach ($paginations as $key => $pg) {
                $pagi .= '<li class="page-item">' . $pg . '</li>';
            }
            $pagi .= '</ul>';
        }

        print _reland_pagi_callback($pagi);
    }
}


// theme color
function reland_custom_color()
{

    // Theme Color
    $color_code = get_theme_mod('reland_color_option', '#BD9A68');
    wp_enqueue_style('reland-custom', RELAND_THEME_CSS_DIR . 'reland-custom.css', []);
    if ($color_code != '') {
        $custom_css = '';
        $custom_css .= "html:root { --tg-primary-color: " . $color_code . "}";
        $custom_css .= "html:root { --unit-primary-color: " . $color_code . "}";
        wp_add_inline_style('reland-custom', $custom_css);
    }

    // Secondary Color
    $color_code2 = get_theme_mod('reland_color_option2', '#202020');
    wp_enqueue_style('reland-custom', RELAND_THEME_CSS_DIR . 'reland-custom.css', []);
    if ($color_code2 != '') {
        $custom_css = '';
        $custom_css .= "html:root { --tg-secondary-color: " . $color_code2 . "}";
        $custom_css .= "html:root { --unit-secondary-color: " . $color_code2 . "}";
        wp_add_inline_style('reland-custom', $custom_css);
    }

    // Menu Color
    $menu_color_code = get_theme_mod('reland_menu_color');
    wp_enqueue_style('reland-custom', RELAND_THEME_CSS_DIR . 'reland-custom.css', []);
    if ($menu_color_code != '') {
        $custom_css = '';
        $custom_css .= ".navbar-wrap > ul > li > a { color: " . $menu_color_code . " !important}";
        wp_add_inline_style('reland-custom', $custom_css);
    }

    // Menu Color
    $reland_menu_hover_color = get_theme_mod('reland_menu_hover_color');
    wp_enqueue_style('reland-custom', RELAND_THEME_CSS_DIR . 'reland-custom.css', []);
    if ($reland_menu_hover_color != '') {
        $custom_css = '';
        $custom_css .= ".navbar-wrap > ul > li:hover > a { color: " . $reland_menu_hover_color . " !important}";
        $custom_css .= ".navbar-wrap > ul > li.active > a { color: " . $reland_menu_hover_color . " !important}";
        wp_add_inline_style('reland-custom', $custom_css);
    }

    // Menu Color
    $reland_menu_sticky_color = get_theme_mod('reland_menu_sticky_color');
    wp_enqueue_style('reland-custom', RELAND_THEME_CSS_DIR . 'reland-custom.css', []);
    if ($reland_menu_sticky_color != '') {
        $custom_css = '';
        $custom_css .= ".sticky-menu .navbar-wrap > ul > li > a { color: " . $reland_menu_sticky_color . " !important}";
        wp_add_inline_style('reland-custom', $custom_css);
    }
}
add_action('wp_enqueue_scripts', 'reland_custom_color');


// reland_kses_intermediate
function reland_kses_intermediate($string = '')
{
    return wp_kses($string, reland_get_allowed_html_tags('intermediate'));
}

function reland_get_allowed_html_tags($level = 'basic')
{
    $allowed_html = [
        'b'      => [],
        'i'      => [],
        'u'      => [],
        'em'     => [],
        'br'     => [],
        'abbr'   => [
            'title' => [],
        ],
        'span'   => [
            'class' => [],
        ],
        'strong' => [],
        'a'      => [
            'href'  => [],
            'title' => [],
            'class' => [],
            'id'    => [],
        ],
    ];

    if ($level === 'intermediate') {
        $allowed_html['a'] = [
            'href' => [],
            'title' => [],
            'class' => [],
            'id' => [],
        ];
        $allowed_html['div'] = [
            'class' => [],
            'id' => [],
        ];
        $allowed_html['img'] = [
            'src' => [],
            'class' => [],
            'alt' => [],
        ];
        $allowed_html['del'] = [
            'class' => [],
        ];
        $allowed_html['ins'] = [
            'class' => [],
        ];
        $allowed_html['bdi'] = [
            'class' => [],
        ];
        $allowed_html['i'] = [
            'class' => [],
            'data-rating-value' => [],
        ];
    }

    return $allowed_html;
}



// WP kses allowed tags
// ----------------------------------------------------------------------------------------
function reland_kses($raw)
{

    $allowed_tags = array(
        'a'      => array(
            'class'   => array(),
            'href'    => array(),
            'rel'  => array(),
            'title'   => array(),
            'target' => array(),
        ),
        'abbr'   => array(
            'title' => array(),
        ),
        'b'    => array(),
        'blockquote'   => array(
            'cite' => array(),
        ),
        'cite'   => array(
            'title' => array(),
        ),
        'code'  => array(),
        'del'   => array(
            'datetime'   => array(),
            'title'      => array(),
        ),
        'dd'     => array(),
        'div'    => array(
            'class'   => array(),
            'title'   => array(),
            'style'   => array(),
        ),
        'dl'   => array(),
        'dt'   => array(),
        'em'   => array(),
        'h1'   => array(),
        'h2'   => array(),
        'h3'   => array(),
        'h4'   => array(),
        'h5'   => array(),
        'h6'   => array(),
        'i'    => array(
            'class' => array(),
        ),
        'img'   => array(
            'alt'  => array(),
            'class'   => array(),
            'height' => array(),
            'src'  => array(),
            'width'   => array(),
        ),
        'li'   => array(
            'class' => array(),
        ),
        'ol'   => array(
            'class' => array(),
        ),
        'p'    => array(
            'class' => array(),
        ),
        'q'    => array(
            'cite'    => array(),
            'title'   => array(),
        ),
        'span'  => array(
            'class'   => array(),
            'title'   => array(),
            'style'   => array(),
        ),
        'iframe'   => array(
            'width'        => array(),
            'height'       => array(),
            'scrolling'    => array(),
            'frameborder'  => array(),
            'allow'        => array(),
            'src'          => array(),
        ),
        'strike'  => array(),
        'br'      => array(),
        'strong'    => array(),
        'data-wow-duration'   => array(),
        'data-wow-delay'   => array(),
        'data-wallpaper-options'  => array(),
        'data-stellar-background-ratio'   => array(),
        'ul'   => array(
            'class' => array(),
        ),
        'svg' => array(
            'class' => true,
            'aria-hidden' => true,
            'aria-labelledby' => true,
            'role' => true,
            'xmlns' => true,
            'width' => true,
            'height' => true,
            'viewbox' => true, // <= Must be lower case!
        ),
        'g'     => array('fill' => true),
        'title' => array('title' => true),
        'path'  => array('d' => true, 'fill' => true,),
    );

    if (function_exists('wp_kses')) { // WP is here
        $allowed = wp_kses($raw, $allowed_tags);
    } else {
        $allowed = $raw;
    }

    return $allowed;
}
