<?php
/**
 * Breadcrumbs for Reland Theme.
 *
 * @package     reland
 * @author      ThemeGenix
 * @copyright   Copyright (c) 2024, ThemeGenix
 * @link        https://www.themegenix.net
 * @since       reland 1.0.0
 */


function reland_breadcrumb_func() {
    global $post;
    $breadcrumb_class = '';
    $breadcrumb_show = 1;

    if ( is_front_page() && is_home() ) {
        $title = get_theme_mod('breadcrumb_blog_title', __('Blog','reland'));
        $breadcrumb_class = 'home_front_page';
    }
    elseif ( is_front_page() ) {
        $title = get_theme_mod('breadcrumb_blog_title', __('Blog','reland'));
        $breadcrumb_show = 0;
    }
    elseif ( is_home() ) {
        if ( get_option( 'page_for_posts' ) ) {
            $title = get_the_title( get_option( 'page_for_posts') );
        }
    }
    elseif ( is_single() && 'post' == get_post_type() ) {
        $breadcrumb_class = 'd-none';
    }
    elseif ( is_single() && 'project' == get_post_type() ) {
        $breadcrumb_class = 'd-none';
    }
    elseif ( is_search() ) {
        $title = esc_html__( 'Search Results for : ', 'reland' ) . get_search_query();
    }
    elseif ( is_404() ) {
        $breadcrumb_class = 'd-none';
    }
    elseif ( is_archive() ) {
        $title = get_the_archive_title();
    }
    else {
        $title = get_the_title();
    }

    $_id = get_the_ID();

    if ( is_single() && 'product' == get_post_type() ) {
        $_id = $post->ID;
    }
    elseif ( is_home() && get_option( 'page_for_posts' ) ) {
        $_id = get_option( 'page_for_posts' );
    }

    $is_breadcrumb = function_exists( 'get_field' ) ? get_field( 'is_it_invisible_breadcrumb', $_id ) : '';
    if( !empty($_GET['s']) ) {
      $is_breadcrumb = null;
    }

    if ( empty( $is_breadcrumb ) && $breadcrumb_show == 1 ) {

        $breadcrumb_hide_default = get_theme_mod('breadcrumb_hide_default', true);

        // Bg color 01
        $breadcrumb_bg_color = get_theme_mod('reland_breadcrumb_bg_color');
        $bg_color = !empty($reland_breadcrumb_bg_color) ? $reland_breadcrumb_bg_color : $breadcrumb_bg_color;

        // Bg color 02
        $breadcrumb_bg_color2 = get_theme_mod('reland_breadcrumb_bg_color2');
        $bg_color2 = !empty($reland_breadcrumb_bg_color2) ? $reland_breadcrumb_bg_color2 : $breadcrumb_bg_color2;

        // get_theme_mod
        $breadcrumb_title_switch = get_theme_mod( 'breadcrumb_title_switch', true );
        $breadcrumb_info_switch = get_theme_mod( 'breadcrumb_info_switch', true );
    ?>


        <?php if (!empty($breadcrumb_hide_default)) : ?>
            <!-- breadcrumb-area -->
            <section class="breadcrumb-area <?php print esc_attr( $breadcrumb_class );?>" style="background: linear-gradient(180deg, <?php print esc_attr($bg_color); ?> 0%, <?php print esc_attr($bg_color2); ?> 100%)">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="breadcrumb-content">
                                <?php if (!empty($breadcrumb_title_switch)) : ?>
                                    <h2 class="title"><?php echo wp_kses_post( $title ); ?></h2>
                                <?php endif; ?>
                                <?php if (!empty($breadcrumb_info_switch)) : ?>
                                    <nav aria-label="breadcrumb" class="breadcrumb">
                                        <?php if(function_exists('bcn_display')) {
                                            bcn_display();
                                        } ?>
                                    </nav>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- breadcrumb-area-end -->
        <?php endif; ?>

    <?php
    }
}

add_action( 'reland_before_main_content', 'reland_breadcrumb_func' );