<?php
namespace Jet_Blocks\Settings;

use Jet_Dashboard\Base\Page_Module as Page_Module_Base;
use Jet_Dashboard\Dashboard as Dashboard;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

class Integrations extends Page_Module_Base {

	/**
	 * Returns module slug
	 *
	 * @return void
	 */
	public function get_page_slug() {
		return 'jet-blocks-integrations-settings';
	}

	/**
	 * [get_subpage_slug description]
	 * @return [type] [description]
	 */
	public function get_parent_slug() {
		return 'settings-page';
	}

	/**
	 * [get_page_name description]
	 * @return [type] [description]
	 */
	public function get_page_name() {
		return esc_html__( 'Integrations', 'jet-dashboard' );
	}

	/**
	 * [get_category description]
	 * @return [type] [description]
	 */
	public function get_category() {
		return 'jet-blocks-settings';
	}

	/**
	 * [get_page_link description]
	 * @return [type] [description]
	 */
	public function get_page_link() {
		return Dashboard::get_instance()->get_dashboard_page_url( $this->get_parent_slug(), $this->get_page_slug() );
	}

	/**
	 * Enqueue module-specific assets
	 *
	 * @return void
	 */
	public function enqueue_module_assets() {

		wp_enqueue_style(
			'jet-blocks-admin-css',
			jet_blocks()->plugin_url( 'assets/css/jet-blocks-admin.css' ),
			false,
			jet_blocks()->get_version()
		);

		wp_enqueue_script(
			'jet-blocks-admin-script',
			jet_blocks()->plugin_url( 'assets/js/jet-blocks-admin-vue-components.js' ),
			array( 'cx-vue-ui', 'wp-api-fetch' ),
			jet_blocks()->get_version(),
			true
		);

		wp_localize_script(
			'jet-blocks-admin-script',
			'JetBlocksSettingsConfig',
			apply_filters( 'jet-blocks/admin/settings-page/localized-config', jet_blocks_settings()->generate_frontend_config_data() )
		);

	}

	/**
	 * License page config
	 *
	 * @param  array  $config  [description]
	 * @param  string $subpage [description]
	 * @return [type]          [description]
	 */
	public function page_config( $config = array(), $page = false, $subpage = false ) {

		$config['pageModule'] = $this->get_parent_slug();
		$config['subPageModule'] = $this->get_page_slug();

		return $config;
	}

	/**
	 * [page_templates description]
	 * @param  array  $templates [description]
	 * @param  string $subpage   [description]
	 * @return [type]            [description]
	 */
	public function page_templates( $templates = array(), $page = false, $subpage = false ) {

		$templates['jet-blocks-integrations-settings'] = jet_blocks()->plugin_path( 'templates/admin-templates/integrations-settings.php' );

		return $templates;
	}
}
