<?php

/**
 * Template part for displaying header layout one
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package reland
 */

// Header Settings
$reland_show_sticky_header = get_theme_mod('reland_show_sticky_header', false);
$sticky_header = $reland_show_sticky_header ? 'sticky-header' : 'sticky-default';

// Header Right
$reland_show_header_email = get_theme_mod('reland_show_header_email', false);
$reland_header_email_address = get_theme_mod('reland_header_email_address', __('relandgroup@mail.com', 'reland'));

$reland_show_header_phone = get_theme_mod('reland_show_header_phone', false);
$reland_header_phone_text = get_theme_mod('reland_header_phone_text', __('+7 495 127 5451', 'reland'));

$reland_show_header_social = get_theme_mod('reland_show_header_social', false);
$reland_header_facebook_url = get_theme_mod('reland_header_facebook_url', __('#', 'reland'));
$reland_header_instagram_url = get_theme_mod('reland_header_instagram_url', __('#', 'reland'));
$reland_header_twitter_url = get_theme_mod('reland_header_twitter_url', __('#', 'reland'));
$reland_header_linkedin_url = get_theme_mod('reland_header_linkedin_url', __('#', 'reland'));

$reland_show_mobile_social = get_theme_mod('reland_show_mobile_social', false);

?>


<!-- header-area -->
<header>
    <div id="<?php echo esc_attr($sticky_header); ?>" class="menu-area-two transparent-header d-none">
        <div class="container custom-container">
            <div class="row">
                <div class="col-12">
                    <div class="menu-wrap">
                        <nav class="menu-nav">
                            <div class="logo-two">
                                <?php reland_header_logo(); ?>
                            </div>
                            <div class="header-action">
                                <ul class="list-wrap">
                                    <?php if (!empty($reland_show_header_email || $reland_show_header_phone)) : ?>
                                        <li class="header-contact">
                                            <ul class="list-wrap">
                                                <?php if (!empty($reland_show_header_email)) : ?>
                                                    <li><a href="mailto:<?php echo esc_attr($reland_header_email_address) ?>"><?php echo esc_html($reland_header_email_address) ?></a></li>
                                                <?php endif; ?>

                                                <?php if (!empty($reland_show_header_phone)) : ?>
                                                    <li><a href="tel:<?php echo esc_attr($reland_header_phone_text); ?>"><?php echo esc_html($reland_header_phone_text); ?></a></li>
                                                <?php endif; ?>
                                            </ul>
                                        </li>
                                    <?php endif; ?>
                                    <li class="icon sideMenu-toggle">
                                        <a href="#">
                                            <span></span>
                                            <span></span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
<!-- header-area-end -->

<!--sidebar-menu -->
<div class="sidebar-menu">
    <div class="sidebar-logo">
        <?php reland_header_logo(); ?>
    </div>
    <div class="navbar-wrap main-menu tgCanvas-menu">
        <?php reland_header_menu(); ?>
    </div>
    <div class="sidebar-contact">
        <?php if (!empty($reland_show_header_email || $reland_show_header_phone)) : ?>
            <ul class="list-wrap">

                <?php if (!empty($reland_show_header_email)) : ?>
                    <li><a href="mailto:<?php echo esc_attr($reland_header_email_address) ?>"><?php echo esc_html($reland_header_email_address) ?></a></li>
                <?php endif; ?>

                <?php if (!empty($reland_show_header_phone)) : ?>
                    <li><a href="tel:<?php echo esc_attr($reland_header_phone_text); ?>"><?php echo esc_html($reland_header_phone_text); ?></a></li>
                <?php endif; ?>

            </ul>
        <?php endif; ?>

        <?php if (!empty($reland_show_header_social)) : ?>
            <div class="sidebar-social">
                <ul class="list-wrap">

                    <?php if (!empty($reland_header_facebook_url)) : ?>
                        <li><a href="<?php echo esc_url($reland_header_facebook_url); ?>"><i class="fab fa-facebook-f"></i></a></li>
                    <?php endif; ?>

                    <?php if (!empty($reland_header_instagram_url)) : ?>
                        <li><a href="<?php echo esc_url($reland_header_instagram_url); ?>"><i class="fab fa-instagram"></i></a></li>
                    <?php endif; ?>

                    <?php if (!empty($reland_header_twitter_url)) : ?>
                        <li>
                            <a href="<?php echo esc_url($reland_header_twitter_url); ?>">
                                <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M8.33192 5.92804L13.5438 0H12.3087L7.78328 5.14724L4.16883 0H0L5.46575 7.78353L0 14H1.2351L6.01407 8.56431L9.83119 14H14L8.33192 5.92804ZM6.64027 7.85211L6.08648 7.07704L1.68013 0.909771H3.57718L7.13316 5.88696L7.68694 6.66202L12.3093 13.1316H10.4123L6.64027 7.85211Z" fill="currentColor" />
                                </svg>
                            </a>
                        </li>
                    <?php endif; ?>

                    <?php if (!empty($reland_header_linkedin_url)) : ?>
                        <li><a href="<?php echo esc_url($reland_header_linkedin_url); ?>"><i class="fab fa-linkedin-in"></i></a></li>
                    <?php endif; ?>

                </ul>
            </div>
        <?php endif; ?>
    </div>
</div>
<div class="sidebar-backdrop"></div>
<!-- sidebar-menu-end -->