<?php

	/**
	* Template part for displaying header layout one
	*
	* @link https://developer.wordpress.org/themes/basics/template-hierarchy/
	*
	* @package reland
	*/

    // Header Settings
    $reland_show_sticky_header = get_theme_mod( 'reland_show_sticky_header', false );
    $sticky_header = $reland_show_sticky_header ? 'sticky-header' : 'sticky-default';

    // Header Right
    $reland_show_header_phone = get_theme_mod( 'reland_show_header_phone', false );
    $reland_header_phone_text = get_theme_mod( 'reland_header_phone_text', __( '+7 495 127 5451', 'reland' ) );

    $reland_show_header_email = get_theme_mod( 'reland_show_header_email', false );
    $reland_header_email_address = get_theme_mod( 'reland_header_email_address', __( 'relandgroup@mail.com', 'reland' ) );

?>


<!-- header-area -->
<header class="fullscreen-menu">
    <nav class="offNav tgCanvas-menu">
        <div class="nav-height">
            <div class="inner">
                <?php reland_hamburger_menu(); ?>
            </div>
        </div>
    </nav>

    <div id="<?php echo esc_attr($sticky_header); ?>" class="menu-area-two transparent-header">
        <div class="container custom-container">
            <div class="row">
                <div class="col-12">
                    <div class="menu-wrap">
                        <nav class="menu-nav">
                            <div class="logo-two">
                                <?php reland_header_logo(); ?>
                            </div>
                            <div class="header-action">
                                <ul class="list-wrap">

                                    <?php if( !empty( $reland_show_header_email || $reland_show_header_phone ) ) : ?>
                                    <li class="header-contact">
                                        <ul class="list-wrap">

                                            <?php if( !empty( $reland_show_header_email ) ) : ?>
                                                <li><a href="mailto:<?php echo esc_attr($reland_header_email_address) ?>"><?php echo esc_html($reland_header_email_address) ?></a></li>
                                            <?php endif; ?>

                                            <?php if ( !empty($reland_show_header_phone) ) : ?>
                                                <li><a href="tel:<?php echo esc_attr($reland_header_phone_text); ?>"><?php echo esc_html($reland_header_phone_text); ?></a></li>
                                            <?php endif; ?>

                                        </ul>
                                    </li>
                                    <?php endif; ?>

                                    <li class="icon burger-menu">
                                        <a href="#">
                                            <span></span>
                                            <span></span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
<!-- header-area-end -->