<?php
/**
 * reland customizer
 *
 * @package reland
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Added Panels & Sections
 */
function reland_customizer_panels_sections( $wp_customize ) {

    //Add panel
    $wp_customize->add_panel( 'reland_customizer', [
        'priority' => 10,
        'title'    => esc_html__( 'Reland Customizer', 'reland' ),
    ] );

    /**
     * Customizer Section
     */
    $wp_customize->add_section( 'reland_default_setting', [
        'title'       => esc_html__( 'Reland Default Setting', 'reland' ),
        'description' => '',
        'priority'    => 10,
        'capability'  => 'edit_theme_options',
        'panel'       => 'reland_customizer',
    ] );

    $wp_customize->add_section( 'header_info_setting', [
        'title'       => esc_html__( 'Header Info Setting', 'reland' ),
        'description' => '',
        'priority'    => 11,
        'capability'  => 'edit_theme_options',
        'panel'       => 'reland_customizer',
    ] );

    $wp_customize->add_section( 'mobile_menu_setting', [
        'title'       => esc_html__( 'Mobile Menu Setting', 'reland' ),
        'description' => '',
        'priority'    => 12,
        'capability'  => 'edit_theme_options',
        'panel'       => 'reland_customizer',
    ] );

    $wp_customize->add_section( 'section_header_logo', [
        'title'       => esc_html__( 'Header Setting', 'reland' ),
        'description' => '',
        'priority'    => 13,
        'capability'  => 'edit_theme_options',
        'panel'       => 'reland_customizer',
    ] );

    $wp_customize->add_section( 'breadcrumb_setting', [
        'title'       => esc_html__( 'Breadcrumb Setting', 'reland' ),
        'description' => '',
        'priority'    => 15,
        'capability'  => 'edit_theme_options',
        'panel'       => 'reland_customizer',
    ] );

    $wp_customize->add_section( 'blog_setting', [
        'title'       => esc_html__( 'Blog Setting', 'reland' ),
        'description' => '',
        'priority'    => 16,
        'capability'  => 'edit_theme_options',
        'panel'       => 'reland_customizer',
    ] );

    $wp_customize->add_section( 'footer_setting', [
        'title'       => esc_html__( 'Footer Settings', 'reland' ),
        'description' => '',
        'priority'    => 17,
        'capability'  => 'edit_theme_options',
        'panel'       => 'reland_customizer',
    ] );

    $wp_customize->add_section( 'color_setting', [
        'title'       => esc_html__( 'Color Setting', 'reland' ),
        'description' => '',
        'priority'    => 18,
        'capability'  => 'edit_theme_options',
        'panel'       => 'reland_customizer',
    ] );

    $wp_customize->add_section( '404_page', [
        'title'       => esc_html__( '404 Page', 'reland' ),
        'description' => '',
        'priority'    => 19,
        'capability'  => 'edit_theme_options',
        'panel'       => 'reland_customizer',
    ] );

    $wp_customize->add_section( 'typo_setting', [
        'title'       => esc_html__( 'Typography Setting', 'reland' ),
        'description' => '',
        'priority'    => 20,
        'capability'  => 'edit_theme_options',
        'panel'       => 'reland_customizer',
    ] );

    $wp_customize->add_section( 'slug_setting', [
        'title'       => esc_html__( 'Slug Settings', 'reland' ),
        'description' => '',
        'priority'    => 21,
        'capability'  => 'edit_theme_options',
        'panel'       => 'reland_customizer',
    ] );
}

add_action( 'customize_register', 'reland_customizer_panels_sections' );


/*
Theme Default Settings
*/
function _reland_default_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'reland_preloader',
        'label'    => esc_html__( 'Preloader ON/OFF', 'reland' ),
        'section'  => 'reland_default_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'reland' ),
            'off' => esc_html__( 'Disable', 'reland' ),
        ],
    ];

    $fields[] = [
        'type'        => 'select',
        'settings'    => 'reland_preloader_select',
        'label'       => esc_html__('Select Preloader Style', 'reland'),
        'section'     => 'reland_default_setting',
        'default'     => 'option-1',
        'placeholder' => esc_html__('Choose an option', 'reland'),
        'choices'     => [
            'option-1' => esc_html__('Default', 'reland'),
            'option-2' => esc_html__('Image Preloader', 'reland'),
        ],
        'active_callback'  => [
            [
                'setting'  => 'reland_preloader',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'preloader_logo',
        'label'       => esc_html__('Preloader Logo', 'reland'),
        'description' => esc_html__('Upload Preloader Logo.', 'reland'),
        'section'     => 'reland_default_setting',
        'default'     => get_template_directory_uri() . '/assets/img/logo/preloader.png',
        'active_callback'  => [
            [
                'setting'  => 'reland_preloader',
                'operator' => '===',
                'value'    => true,
            ],
            [
                'setting'  => 'reland_preloader_select',
                'operator' => '===',
                'value'    => 'option-2',
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'reland_backtotop',
        'label'    => esc_html__( 'Back to Top ON/OFF', 'reland' ),
        'section'  => 'reland_default_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'reland' ),
            'off' => esc_html__( 'Disable', 'reland' ),
        ],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_reland_default_fields' );


/*
Header Right Settings
*/
function _header_right_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'reland_show_header_location',
        'label'    => esc_html__( 'Show Header Location', 'reland' ),
        'section'  => 'header_info_setting',
        'description' => esc_html__( 'It works for header style 5 & 6', 'reland' ),
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'reland' ),
            'off' => esc_html__( 'Disable', 'reland' ),
        ],
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'reland_header_location_text',
        'label'    => esc_html__( 'Enter Location Text', 'reland' ),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_header_location',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__( '1940 El Cajon Blvd, San Diego, CA 92104, United States', 'reland' ),
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'reland_show_header_email',
        'label'    => esc_html__( 'Show Header Email', 'reland' ),
        'section'  => 'header_info_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'reland' ),
            'off' => esc_html__( 'Disable', 'reland' ),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_header_email_address',
        'label'    => esc_html__( 'Enter Email Address', 'reland' ),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_header_email',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__( 'relandgroup@mail.com', 'reland' ),
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'reland_show_header_social',
        'label'    => esc_html__( 'Show Header Social', 'reland' ),
        'section'  => 'header_info_setting',
        'description' => esc_html__( 'It works for header style (1) & (7)', 'reland' ),
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'reland' ),
            'off' => esc_html__( 'Disable', 'reland' ),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_header_facebook_url',
        'label'    => esc_html__( 'Facebook URL', 'reland' ),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_header_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__( '#', 'reland' ),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_header_instagram_url',
        'label'    => esc_html__( 'Instagram URL', 'reland' ),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_header_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__( '#', 'reland' ),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_header_twitter_url',
        'label'    => esc_html__( 'Twitter URL', 'reland' ),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_header_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__( '#', 'reland' ),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_header_linkedin_url',
        'label'    => esc_html__( 'Linkedin URL', 'reland' ),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_header_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__( '#', 'reland' ),
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'reland_show_header_phone',
        'label'    => esc_html__( 'Show Header Phone', 'reland' ),
        'section'  => 'header_info_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'reland' ),
            'off' => esc_html__( 'Disable', 'reland' ),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_header_phone_text',
        'label'    => esc_html__( 'Enter Phone Number', 'reland' ),
        'section'  => 'header_info_setting',
        'priority' => 10,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_header_phone',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__( '+7 495 127 5451', 'reland' ),
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_right_fields' );

/*
Mobile Menu Settings
*/
function _mobile_menu_fields( $fields ) {

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'mobile_logo',
        'label'       => esc_html__( 'Mobile Menu Logo Dark', 'reland' ),
        'description' => esc_html__( 'Upload Your Logo.', 'reland' ),
        'section'     => 'mobile_menu_setting',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo.png',
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'reland_show_mobile_social',
        'label'    => esc_html__( 'Show Mobile Menu Social', 'reland' ),
        'section'  => 'mobile_menu_setting',
        'default'  => 0,
        'priority' => 12,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'reland' ),
            'off' => esc_html__( 'Disable', 'reland' ),
        ],
    ];

    // Mobile section social
    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_mobile_fb_url',
        'label'    => esc_html__( 'Facebook URL', 'reland' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'reland' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_mobile_twitter_url',
        'label'    => esc_html__( 'Twitter URL', 'reland' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'reland' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_mobile_instagram_url',
        'label'    => esc_html__( 'Instagram URL', 'reland' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'reland' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_mobile_linkedin_url',
        'label'    => esc_html__( 'Linkedin URL', 'reland' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'reland' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_mobile_telegram_url',
        'label'    => esc_html__( 'Telegram URL', 'reland' ),
        'section'  => 'mobile_menu_setting',
        'default'  => esc_html__( '#', 'reland' ),
        'priority' => 12,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_mobile_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_mobile_menu_fields' );


/*
Header Settings
 */
function _header_header_fields( $fields ) {

    // Sticky Header
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'reland_show_sticky_header',
        'label'    => esc_html__( 'Show Sticky Header', 'reland' ),
        'section'  => 'section_header_logo',
        'default'  => 0,
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'reland' ),
            'off' => esc_html__( 'Disable', 'reland' ),
        ],
    ];

    $fields[] = [
        'type'        => 'radio-image',
        'settings'    => 'choose_default_header',
        'label'       => esc_html__( 'Select Header Style', 'reland' ),
        'description' => esc_html__('If this option does not work, It means the header style is selected from an edit page. So go to the edit page then change the header style from there.', 'reland'),
        'section'     => 'section_header_logo',
        'placeholder' => esc_html__( 'Select an option...', 'reland' ),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            'header-style-1' => get_template_directory_uri() . '/inc/img/header/header-1.png',
            'header-style-2' => get_template_directory_uri() . '/inc/img/header/header-2.png',
            'header-style-3' => get_template_directory_uri() . '/inc/img/header/header-3.png',
            'header-style-4' => get_template_directory_uri() . '/inc/img/header/header-4.png',
            'header-style-5' => get_template_directory_uri() . '/inc/img/header/header-5.png',
            'header-style-6' => get_template_directory_uri() . '/inc/img/header/header-6.png',
            'header-style-7' => get_template_directory_uri() . '/inc/img/header/header-7.png',
            'header-style-8' => get_template_directory_uri() . '/inc/img/header/header-8.png',
        ],
        'default'     => 'header-style-1',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'logo',
        'label'       => esc_html__( 'Header Logo', 'reland' ),
        'description' => esc_html__( 'Upload Your Logo', 'reland' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/logo.png',
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'secondary_logo',
        'label'       => esc_html__( 'Header Secondary Logo', 'reland' ),
        'description' => esc_html__( 'Upload Your Logo', 'reland' ),
        'section'     => 'section_header_logo',
        'default'     => get_template_directory_uri() . '/assets/img/logo/secondary_logo.png',
    ];

    $fields[] = [
        'type'        => 'dimension',
        'settings'    => 'logo_size_adjust',
		'label'       => esc_html__( 'Logo Size', 'reland' ),
		'description' => esc_html__( 'Adjust your logo size with px', 'reland' ),
		'section'     => 'section_header_logo',
		'default'     => '111px',
        'choices'     => [
			'accept_unitless' => true,
		],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_header_fields' );

/*
_header_page_title_fields
 */
function _header_page_title_fields( $fields ) {

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'breadcrumb_hide_default',
        'label'    => esc_html__('Breadcrumb Hide by Default', 'reland'),
        'section'  => 'breadcrumb_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__('Enable', 'reland'),
            'off' => esc_html__('Disable', 'reland'),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'breadcrumb_title_switch',
        'label'    => esc_html__( 'Breadcrumb Title switch', 'reland' ),
        'section'  => 'breadcrumb_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'reland' ),
            'off' => esc_html__( 'Disable', 'reland' ),
        ],
        'active_callback'  => [
            [
                'setting'  => 'breadcrumb_hide_default',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'breadcrumb_info_switch',
        'label'    => esc_html__( 'Breadcrumb Info switch', 'reland' ),
        'section'  => 'breadcrumb_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'reland' ),
            'off' => esc_html__( 'Disable', 'reland' ),
        ],
        'active_callback'  => [
            [
                'setting'  => 'breadcrumb_hide_default',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'reland_breadcrumb_bg_color',
        'label'       => __('Background Top Color', 'reland'),
        'description' => esc_html__('This is a gradient top color control.', 'reland'),
        'section'     => 'breadcrumb_setting',
        'default'     => '#F9FAF1',
        'priority'    => 11,
        'active_callback'  => [
            [
                'setting'  => 'breadcrumb_hide_default',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'reland_breadcrumb_bg_color2',
        'label'       => __('Background Bottom Color', 'reland'),
        'description' => esc_html__('This is a gradient bottom color control.', 'reland'),
        'section'     => 'breadcrumb_setting',
        'default'     => '#FEFFFB',
        'priority'    => 11,
        'active_callback'  => [
            [
                'setting'  => 'breadcrumb_hide_default',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_page_title_fields' );

/*
Header Social
 */
function _header_blog_fields( $fields ) {
// Blog Setting
    $fields[] = [
        'type'     => 'switch',
        'settings' => 'reland_blog_btn_switch',
        'label'    => esc_html__( 'Blog Button ON/OFF', 'reland' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'reland' ),
            'off' => esc_html__( 'Disable', 'reland' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'reland_blog_cat',
        'label'    => esc_html__( 'Blog Category Meta ON/OFF', 'reland' ),
        'section'  => 'blog_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'reland' ),
            'off' => esc_html__( 'Disable', 'reland' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'reland_blog_author',
        'label'    => esc_html__( 'Blog Author Meta ON/OFF', 'reland' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'reland' ),
            'off' => esc_html__( 'Disable', 'reland' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'reland_blog_date',
        'label'    => esc_html__( 'Blog Date Meta ON/OFF', 'reland' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'reland' ),
            'off' => esc_html__( 'Disable', 'reland' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'reland_blog_comments',
        'label'    => esc_html__( 'Blog Comments Meta ON/OFF', 'reland' ),
        'section'  => 'blog_setting',
        'default'  => '1',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'reland' ),
            'off' => esc_html__( 'Disable', 'reland' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'reland_show_blog_share',
        'label'    => esc_html__( 'Show Blog Share', 'reland' ),
        'section'  => 'blog_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'reland' ),
            'off' => esc_html__( 'Disable', 'reland' ),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_blog_btn',
        'label'    => esc_html__( 'Blog Button text', 'reland' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Read More', 'reland' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'breadcrumb_blog_title',
        'label'    => esc_html__( 'Blog Title', 'reland' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Blog', 'reland' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'breadcrumb_blog_title_details',
        'label'    => esc_html__( 'Blog Details Title', 'reland' ),
        'section'  => 'blog_setting',
        'default'  => esc_html__( 'Blog Details', 'reland' ),
        'priority' => 10,
    ];
    return $fields;
}
add_filter( 'kirki/fields', '_header_blog_fields' );

/*
Footer
 */
function _header_footer_fields( $fields ) {
    // Footer Setting
    $fields[] = [
        'type'        => 'radio-image',
        'settings'    => 'choose_default_footer',
        'label'       => esc_html__( 'Choose Footer Style', 'reland' ),
        'section'     => 'footer_setting',
        'default'     => '5',
        'placeholder' => esc_html__( 'Select an option...', 'reland' ),
        'priority'    => 10,
        'multiple'    => 1,
        'choices'     => [
            'footer-style-1'   => get_template_directory_uri() . '/inc/img/footer/footer-1.png',
        ],
        'default'     => 'footer-style-1',
    ];

    $fields[] = [
        'type'        => 'select',
        'settings'    => 'footer_widget_number',
        'label'       => esc_html__( 'Widget Number', 'reland' ),
        'section'     => 'footer_setting',
        'default'     => '4',
        'placeholder' => esc_html__( 'Select an option...', 'reland' ),
        'priority'    => 11,
        'multiple'    => 1,
        'choices'     => [
            '4' => esc_html__( 'Widget Number 4', 'reland' ),
            '3' => esc_html__( 'Widget Number 3', 'reland' ),
            '2' => esc_html__( 'Widget Number 2', 'reland' ),
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'reland_footer_bg',
        'label'       => esc_html__( 'Footer Background Image.', 'reland' ),
        'description' => esc_html__( 'Footer Background Image.', 'reland' ),
        'priority'    => 12,
        'section'     => 'footer_setting',
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'reland_footer_bg_color',
        'label'       => __( 'Footer BG Color', 'reland' ),
        'description' => esc_html__( 'This is a Footer bg color control.', 'reland' ),
        'section'     => 'footer_setting',
        'default'     => '#202020',
        'priority'    => 13,
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'reland_show_footer_social',
        'label'    => esc_html__( 'Show Footer Social', 'reland' ),
        'section'  => 'footer_setting',
        'default'  => '0',
        'priority' => 14,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'reland' ),
            'off' => esc_html__( 'Disable', 'reland' ),
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_footer_facebook_url',
        'label'    => esc_html__( 'Facebook URL', 'reland' ),
        'section'  => 'footer_setting',
        'priority' => 14,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_footer_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__( '#', 'reland' ),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_footer_instagram_url',
        'label'    => esc_html__( 'Instagram URL', 'reland' ),
        'section'  => 'footer_setting',
        'priority' => 14,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_footer_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__( '#', 'reland' ),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_footer_twitter_url',
        'label'    => esc_html__( 'Twitter URL', 'reland' ),
        'section'  => 'footer_setting',
        'priority' => 14,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_footer_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__( '#', 'reland' ),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_footer_linkedin_url',
        'label'    => esc_html__( 'Linkedin URL', 'reland' ),
        'section'  => 'footer_setting',
        'priority' => 14,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_footer_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
        'default'  => esc_html__( '#', 'reland' ),
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_footer_telegram_url',
        'label'    => esc_html__( 'Telegram URL', 'reland' ),
        'section'  => 'footer_setting',
        'priority' => 14,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_footer_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_footer_youtube_url',
        'label'    => esc_html__( 'Youtube URL', 'reland' ),
        'section'  => 'footer_setting',
        'priority' => 14,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_footer_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_footer_discord_url',
        'label'    => esc_html__( 'Discord URL', 'reland' ),
        'section'  => 'footer_setting',
        'priority' => 14,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_footer_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_footer_whatsapp_url',
        'label'    => esc_html__( 'Whatsapp URL', 'reland' ),
        'section'  => 'footer_setting',
        'priority' => 14,
        'active_callback'  => [
            [
                'setting'  => 'reland_show_footer_social',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_copyright',
        'label'    => esc_html__( 'CopyRight', 'reland' ),
        'section'  => 'footer_setting',
        'default'  => wp_kses_post( 'Copyright © <span>Reland</span> 2024. All Rights Reserved', 'reland' ),
        'priority' => 15,
    ];

    return $fields;
}
add_filter( 'kirki/fields', '_header_footer_fields' );

// Color
function reland_color_fields( $fields ) {

    // Color Settings
    $fields[] = [
        'type'        => 'color',
        'settings'    => 'reland_color_option',
        'label'       => __( 'Theme Color', 'reland' ),
        'description' => esc_html__( 'This is a Theme color control.', 'reland' ),
        'section'     => 'color_setting',
        'default'     => '#BD9A68',
        'priority'    => 10,
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'reland_color_option2',
        'label'       => __( 'Secondary Color', 'reland' ),
        'description' => esc_html__( 'This is a Secondary color control.', 'reland' ),
        'section'     => 'color_setting',
        'default'     => '#202020',
        'priority'    => 10,
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'reland_menu_color',
        'label'       => __( 'Menu Normal Color', 'reland' ),
        'description' => esc_html__( 'This is a Menu by default color control.', 'reland' ),
        'section'     => 'color_setting',
        'priority'    => 10,
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'reland_menu_hover_color',
        'label'       => __( 'Menu Hover & Active Color', 'reland' ),
        'description' => esc_html__( 'This is a Menu hover color control.', 'reland' ),
        'section'     => 'color_setting',
        'priority'    => 10,
    ];

    $fields[] = [
        'type'        => 'color',
        'settings'    => 'reland_menu_sticky_color',
        'label'       => __( 'Sticky Menu Color', 'reland' ),
        'description' => esc_html__( 'This is a Menu sticky color control.', 'reland' ),
        'section'     => 'color_setting',
        'priority'    => 10,
    ];

    return $fields;
}
add_filter( 'kirki/fields', 'reland_color_fields' );

// 404
function reland_404_fields( $fields ) {
    // 404 settings
    $fields[] = [
        'type'        => 'image',
        'settings'    => 'reland_error_bg',
        'label'       => esc_html__( 'Background Image', 'reland' ),
        'description' => esc_html__( 'Upload 404 Image', 'reland' ),
        'section'     => '404_page',
        'default'     => get_template_directory_uri() . '/assets/img/images/error_shape.png',
    ];

    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'reland_error_title',
        'label'    => esc_html__( 'Not Found Title', 'reland' ),
        'section'  => '404_page',
        'default'  => esc_html__( 'The page you are looking for might have been removed or temporarily unavailable', 'reland' ),
        'priority' => 10,
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_error_link_text',
        'label'    => esc_html__( '404 Link Text', 'reland' ),
        'section'  => '404_page',
        'default'  => esc_html__( 'Back To Home', 'reland' ),
        'priority' => 10,
    ];
    return $fields;
}
add_filter( 'kirki/fields', 'reland_404_fields' );


/**
 * Added Fields
 */
function reland_typo_fields( $fields ) {
    // typography settings
    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_body_setting',
        'label'       => esc_html__( 'Body Font', 'reland' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'body',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h_setting',
        'label'       => esc_html__( 'Heading h1 Fonts', 'reland' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h1',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h2_setting',
        'label'       => esc_html__( 'Heading h2 Fonts', 'reland' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h2',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h3_setting',
        'label'       => esc_html__( 'Heading h3 Fonts', 'reland' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h3',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h4_setting',
        'label'       => esc_html__( 'Heading h4 Fonts', 'reland' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h4',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h5_setting',
        'label'       => esc_html__( 'Heading h5 Fonts', 'reland' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h5',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h6_setting',
        'label'       => esc_html__( 'Heading h6 Fonts', 'reland' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h6',
            ],
        ],
    ];
    return $fields;
}

add_filter( 'kirki/fields', 'reland_typo_fields' );


/**
 * Added Fields
 */
function reland_slug_setting( $fields ) {
    // slug settings
    $fields[] = [
        'type'     => 'text',
        'settings' => 'reland_project_slug',
        'label'    => esc_html__( 'Project Slug', 'reland' ),
        'description' => esc_html__('After change slug you have to update permalinks "Post Name"', 'reland'),
        'section'  => 'slug_setting',
        'default'  => esc_html__('project', 'reland' ),
        'priority' => 10,
    ];

    return $fields;
}

add_filter( 'kirki/fields', 'reland_slug_setting' );


/**
 * This is a short hand function for getting setting value from customizer
 *
 * @param string $name
 *
 * @return bool|string
 */
function RELAND_THEME_option( $name ) {
    $value = '';
    if ( class_exists( 'reland' ) ) {
        $value = Kirki::get_option( reland_get_theme(), $name );
    }

    return apply_filters( 'RELAND_THEME_option', $value, $name );
}

/**
 * Get config ID
 *
 * @return string
 */
function reland_get_theme() {
    return 'reland';
}