<?php

/**
 * reland_scripts description
 * @return [type] [description]
 */
function reland_scripts() {


    /**
     * ALL CSS FILES
    */
    wp_enqueue_style( 'reland-fonts', reland_fonts_url(), array(), '1.0.0' );
    if( is_rtl() ){
        wp_enqueue_style( 'bootstrap-rtl', RELAND_THEME_CSS_DIR.'bootstrap.rtl.min.css', array() );
    }else{
        wp_enqueue_style( 'bootstrap', RELAND_THEME_CSS_DIR.'bootstrap.min.css', array() );
    }
    wp_enqueue_style( 'reland-animate', RELAND_THEME_CSS_DIR . 'animate.min.css', [] );
    wp_enqueue_style( 'magnific-popup', RELAND_THEME_CSS_DIR . 'magnific-popup.css', [] );
    wp_enqueue_style( 'font-awesome-free', RELAND_THEME_CSS_DIR . 'fontawesome-all.min.css', [] );
    wp_enqueue_style( 'odometer', RELAND_THEME_CSS_DIR . 'odometer.css', [] );
    wp_enqueue_style( 'swiper-bundle', RELAND_THEME_CSS_DIR . 'swiper-bundle.min.css', [] );
    wp_enqueue_style( 'slick', RELAND_THEME_CSS_DIR . 'slick.css', [] );
    wp_enqueue_style( 'reland-spacing', RELAND_THEME_CSS_DIR . 'spacing.css', [] );
    wp_enqueue_style( 'reland-flaticon', RELAND_THEME_CSS_DIR . 'flaticon.css', [] );
    wp_enqueue_style( 'reland-core', RELAND_THEME_CSS_DIR . 'reland-core.css', [] );
    wp_enqueue_style( 'reland-unit', RELAND_THEME_CSS_DIR . 'reland-unit.css', [] );
    wp_enqueue_style( 'reland-style', get_stylesheet_uri() );
    wp_enqueue_style( 'reland-responsive', RELAND_THEME_CSS_DIR . 'responsive.css', [] );


    // ALL JS FILES
    wp_enqueue_script( 'bootstrap-bundle', RELAND_THEME_JS_DIR . 'bootstrap.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'magnific-popup', RELAND_THEME_JS_DIR . 'jquery.magnific-popup.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'odometer', RELAND_THEME_JS_DIR . 'jquery.odometer.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'parallaxScroll', RELAND_THEME_JS_DIR . 'jquery.parallaxScroll.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'simpleParallax', RELAND_THEME_JS_DIR . 'simpleParallax.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'swiper-bundle', RELAND_THEME_JS_DIR . 'swiper-bundle.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'slick', RELAND_THEME_JS_DIR . 'slick.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'slick-animation', RELAND_THEME_JS_DIR . 'slick-animation.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'jarallax', RELAND_THEME_JS_DIR . 'jarallax.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'jarallax-video', RELAND_THEME_JS_DIR . 'jarallax-video.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'appear', RELAND_THEME_JS_DIR . 'jquery.appear.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'easing', RELAND_THEME_JS_DIR . 'jquery.easing.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'wow', RELAND_THEME_JS_DIR . 'wow.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'reland-main', RELAND_THEME_JS_DIR . 'main.js', [ 'jquery' ], false, true );

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
}
add_action( 'wp_enqueue_scripts', 'reland_scripts' );

/*
Register Fonts
*/
function reland_fonts_url() {
    $font_url = '';

    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
    */
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'reland' ) ) {
        $font_url = add_query_arg( 'family', 'Montserrat:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700|Vidaloka' , "//fonts.googleapis.com/css");
    }
    return $font_url;
}