<?php

include_once "values.php";
include_once "copyTypeDeBien.php";

function appendXmlFields(SimpleXMLElement $source, SimpleXMLElement $destination) {
    foreach ($source as $key => $value) {
        // Add each child from source into destination
        $destination->addChild($key, htmlspecialchars((string) $value));
    }
}

// URL of the remote XML file
$remoteUrl = 'https://clients.immo-facile.com/office20/homesweet_030423/cache/export.xml';

// Path to the new local file
$localFile = __DIR__ . '/biens.xml';

// Step 1: Download the XML
$xmlContent = file_get_contents($remoteUrl);

if ($xmlContent === false) {
    die("❌ Failed to fetch XML from $remoteUrl\n");
}

// Step 2: Parse the XML (optional - useful to validate it)
libxml_use_internal_errors(true);
$xml = simplexml_load_string($xmlContent);

if ($xml === false) {
    echo "❌ Failed to parse XML:\n";
    foreach (libxml_get_errors() as $error) {
        echo "  - " . $error->message;
    }
    exit(1);
}

$xml1 = new SimpleXMLElement('<biens></biens>');

foreach ($xml->BIEN as $BIEN) {
    $bien1 = $xml1->addChild('bien');
    
    $bien1->addChild("id",$BIEN->INFO_GENERALES->AFF_ID);
    $bien1->addChild("date_creation", $BIEN->INFO_GENERALES->DATE_CREATION);
    $bien1->addChild("date_maj", $BIEN->INFO_GENERALES->DATE_MAJ);
    $bien1->addChild("titre", $BIEN->INTITULE->FR);
    $bien1->addChild("description", $BIEN->COMMENTAIRES->FR);
    $bien1->addChild("ville", $BIEN->LOCALISATION->VILLE);
    $bien1->addChild("cp", $BIEN->LOCALISATION->CODE_POSTAL);

    
    echo($BIEN->COUP_COEUR);

    // $bien1->addChild("pictogramme", getBordDescription("1"));
    if(isset($BIEN->APPARTEMENT)){

    }

    if(isset($BIEN->COUP_COEUR)){
        $bien1->addChild("Coup de coeur", $BIEN->COUP_COEUR );
    }

    if(isset($BIEN->PICTOGRAMME)){
        $bien1->addChild("pictogramme", getBordDescription($BIEN->PICTOGRAMME));
    }
    
    if(isset($BIEN->LOCATION)){
        $bien1->addChild("type", "location");
        foreach ($BIEN->LOCATION->children() as $key => $value) {
            if ($key == "LOYER")    
            {
                $bien1->addChild("prix", htmlspecialchars((string) $value));
            }
            else
            $bien1->addChild($key, htmlspecialchars((string) $value));
        }
    }

    elseif(isset($BIEN->VENTE)){
        $bien1->addChild("type", "vente");
        foreach ($BIEN->VENTE->children() as $key => $value) {
            if ($key == "PRIX")    
            {
                $bien1->addChild("prix", htmlspecialchars((string) $value));
            }
            else
            $bien1->addChild($key, htmlspecialchars((string) $value));
        }
    }

    if (isset($BIEN->LOCALISATION)){
        $localisation = $bien1->addChild('localisation');
        foreach ($BIEN->LOCALISATION->children() as $key => $value) 
            {
                $localisation->addChild($key, htmlspecialchars((string) $value));
            }
    }

    copyTypeDeBien($BIEN, $bien1);
    
    if (isset($BIEN->IMAGES))
    {
        if(isset($BIEN->IMAGES->IMG))
        {
            $img = $bien1->addChild('img');
            foreach ($BIEN->IMAGES->IMG as $key => $value) 
            {
                $img->addChild($key, htmlspecialchars((string) $value));
            }
        }
    }

    
}

$savePath = __DIR__ . '/biens1.xml';
$xml1->asXML($savePath);

// Step 2: Convert to DOMDocument for pretty-print
$dom = new DOMDocument('1.0', 'UTF-8');
$dom->preserveWhiteSpace = false;
$dom->formatOutput = true;

// Load SimpleXML into DOM
$dom->loadXML($xml1->asXML());

// Step 3: Save to new file
file_put_contents($localFile, $xmlContent);
$dom->save(__DIR__ . '/biens_pretty.xml');

echo "✅ XML saved successfully to biens.xml\n";
