<?php

/**
 * Template part for displaying header layout one
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package reland
 */

// Header Settings
$reland_show_sticky_header = get_theme_mod('reland_show_sticky_header', false);
$sticky_header = $reland_show_sticky_header ? 'sticky-header' : 'sticky-default';

// Header Right
$reland_show_header_location = get_theme_mod('reland_show_header_location', false);
$reland_header_location_text = get_theme_mod('reland_header_location_text', __('1940 El Cajon Blvd, San Diego, CA 92104, United States', 'reland'));

$reland_show_header_email = get_theme_mod('reland_show_header_email', false);
$reland_header_email_address = get_theme_mod('reland_header_email_address', __('relandgroup@mail.com', 'reland'));

$reland_show_header_phone = get_theme_mod('reland_show_header_phone', false);
$reland_header_phone_text = get_theme_mod('reland_header_phone_text', __('+7 495 127 5451', 'reland'));

$reland_header_location_center = $reland_show_header_email || $reland_show_header_phone ? 'col-lg-6' : 'col-12 text-center';
$reland_header_justify = $reland_show_header_location ? '' : 'justify-content-center';
$reland_header_top0 = $reland_show_header_location || $reland_show_header_email || $reland_show_header_phone ? '' : 'top-0';

$reland_show_mobile_social = get_theme_mod('reland_show_mobile_social', false);

?>


<!-- header-area -->
<header class="header-style-six">

    <?php if (!empty($reland_show_header_location || $reland_show_header_email || $reland_show_header_phone)) : ?>
        <div class="header-top">
            <div class="container custom-container">
                <div class="row align-items-center justify-content-center">

                    <?php if (!empty($reland_show_header_location)) : ?>
                        <div class="<?php echo esc_attr($reland_header_location_center); ?>">
                            <div class="header-top-left">
                                <p><?php echo esc_html($reland_header_location_text); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($reland_show_header_email || $reland_show_header_phone)) : ?>
                        <div class="col-lg-6">
                            <div class="header-top-right">
                                <ul class="list-wrap <?php echo esc_attr($reland_header_justify); ?>">

                                    <?php if (!empty($reland_show_header_email)) : ?>
                                        <li><a href="mailto:<?php echo esc_attr($reland_header_email_address); ?>"><?php echo esc_html($reland_header_email_address); ?></a></li>
                                    <?php endif; ?>

                                    <?php if (!empty($reland_show_header_phone)) : ?>
                                        <li><a href="tel:<?php echo esc_attr($reland_header_phone_text); ?>"><?php echo esc_html($reland_header_phone_text); ?></a></li>
                                    <?php endif; ?>

                                </ul>
                            </div>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    <?php endif; ?>

    <div id="<?php echo esc_attr($sticky_header); ?>" class="menu-area transparent-header <?php echo esc_attr($reland_header_top0); ?>">
        <div class="container custom-container">
            <div class="row">
                <div class="col-12">
                    <div class="menu-wrap">
                        <nav class="menu-nav d-flex align-items-center d-lg-block">
                            <div class="logo mobile-logo d-none">
                                <?php reland_header_logo(); ?>
                            </div>
                            <div id="split-menu" class="navbar-wrap main-menu d-none d-lg-flex">
                                <?php reland_header_menu(); ?>
                                <div class="logo">
                                    <?php reland_header_logo(); ?>
                                </div>
                                <ul class="navigation right"></ul>
                            </div>
                            <div class="mobile-nav-toggler"><i class="fas fa-bars"></i></div>
                        </nav>
                    </div>

                    <!-- Mobile Menu  -->
                    <div class="mobile-menu">
                        <nav class="menu-box">
                            <div class="close-btn"><i class="fas fa-times"></i></div>
                            <div class="nav-logo">
                                <?php reland_mobile_logo(); ?>
                            </div>
                            <div class="menu-outer">
                                <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
                            </div>

                            <?php if (!empty($reland_show_mobile_social)) : ?>
                                <div class="social-links">
                                    <?php reland_mobile_social_profiles(); ?>
                                </div>
                            <?php endif; ?>

                        </nav>
                    </div>
                    <div class="menu-backdrop"></div>
                    <!-- End Mobile Menu -->

                </div>
            </div>
        </div>
    </div>
</header>
<!-- header-area-end -->