(function ($) {
	"use strict";

/*=============================================
	=    		 Preloader			      =
=============================================*/
$(window).on('load', function () {
	preloader();
	wowAnimation();
});

function preloader() {
	$('#preloader').delay(0).fadeOut();
};


/*=============================================
	=          Click To Section     =
=============================================*/
$(document).ready(function () {
	$("html").css('scroll-behavior', 'auto');
});
//jQuery for page scrolling feature - requires jQuery Easing plugin
$(function () {
	$('a.section-link[href*="#"]:not([href="#"])').on('click', function () {
		if (location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') && location.hostname == this.hostname) {
			var target = $(this.hash);
			target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
			if (target.length) {
				$('html, body').animate({
					scrollTop: (target.offset().top - 80)
				}, 1200, "easeInOutExpo");
				return false;
			}
		}
	});
});


/*=============================================
	=    		Mobile Menu			      =
=============================================*/
//SubMenu Dropdown Toggle
if ($('.menu-area li.menu-item-has-children ul').length) {
	$('.menu-area .navigation li.menu-item-has-children').append('<div class="dropdown-btn"><span class="fas fa-angle-down"></span></div>');

}

//Mobile Nav Hide Show
if ($('.mobile-menu').length) {

	var mobileMenuContent = $('.menu-area .main-menu').html();
	$('.mobile-menu .menu-box .menu-outer').append(mobileMenuContent);

	//Dropdown Button
	$('.mobile-menu li.menu-item-has-children .dropdown-btn').on('click', function () {
		$(this).toggleClass('open');
		$(this).prev('ul').slideToggle(300);
	});
	//Menu Toggle Btn
	$('.mobile-nav-toggler').on('click', function () {
		$('body').addClass('mobile-menu-visible');
	});

	//Menu Toggle Btn
	$('.menu-backdrop, .mobile-menu .close-btn').on('click', function () {
		$('body').removeClass('mobile-menu-visible');
	});
}


/*===========================================
	=          Menu slice      =
=============================================*/
let length = $('#split-menu #menu-main-menu>li').length < 1 ? $('#split-menu .navigation>li').length : $('#split-menu #menu-main-menu>li').length;

for(let i = Math.ceil(length / 2); i <= length; i++) {
    if( $('#split-menu #menu-main-menu>li').length < 1) {
        $('#split-menu .navigation>li').slice(i).appendTo('#split-menu .navigation.right');
        $('#split-menu .navigation>li').slice(i).appendTo('#split-menu .navigation.right');
    } else{
        $('#split-menu #menu-main-menu>li').slice(i).appendTo('#split-menu .navigation.right');
        $('#split-menu #menu-main-menu>li').slice(i).appendTo('#split-menu .navigation.right');
    }
}


/*=============================================
	=     Menu sticky & Scroll to top      =
=============================================*/
$(window).on('scroll', function () {
	var scroll = $(window).scrollTop();
	if (scroll < 245) {
		$("#sticky-header").removeClass("sticky-menu");
        $('.scroll-to-target').removeClass('open');
		$("#header-fixed-height").removeClass("active-height");

	} else {
		$("#sticky-header").addClass("sticky-menu");
        $('.scroll-to-target').addClass('open');
		$("#header-fixed-height").addClass("active-height");
	}
});


/*=============================================
	=    		 Scroll Up  	         =
=============================================*/
if ($('.scroll-to-target, .section-link-two').length) {
  $(".scroll-to-target, .section-link-two").on('click', function () {
    var target = $(this).attr('data-target');
    // animate
    $('html, body').animate({
      scrollTop: $(target).offset().top
    }, 1000);

  });
}


/*=============================================
	=          Data Background               =
=============================================*/
$("[data-background]").each(function () {
	$(this).css("background-image", "url(" + $(this).attr("data-background") + ")")
});

$("[data-bg-color]").each(function () {
	$(this).css("background-color", $(this).attr("data-bg-color"));
});


/*=============================================
	=    		 Jarallax Active  	         =
=============================================*/
$('.jarallax').jarallax({
    speed: 0.2,
});


/*=============================================
	=     Side Menu Active  	       =
=============================================*/
$('.sideMenu-toggle').on('click', function () {
    $('body').addClass('side-menu-visible');
    return false
});

//Menu Backdrop
$('.sidebar-backdrop').on('click', function () {
    $('body').removeClass('side-menu-visible');
});


/*=============================================
	=     OffNav Menu Active  	       =
=============================================*/
//Menu Toggle Btn
$('.burger-menu').on('click', function (e) {
    $(this).toggleClass('active');
    e.preventDefault();
    if ($('body').hasClass('burger-menu-visible')) {
        setTimeout(function () {
            $('body').removeClass('burger-menu-visible');
        }, 900);
    } else {
        $('body').addClass('burger-menu-visible');
    }
});

//Menu Toggle Btn
$('.tgCanvas-backdrop').on('click', function () {
    $('.burger-menu').removeClass('active');
    setTimeout(function () {
        $('body').removeClass('burger-menu-visible');
    }, 900);
});

//SubMenu Dropdown Toggle
if ($('.tgCanvas-menu li.menu-item-has-children').length) {
	$('.tgCanvas-menu li.menu-item-has-children').append('<i class="dropdown-icon"></i>');
}
$(".tgCanvas-menu .dropdown-icon").on('click', function() {
    var $tgMenu = $(this);
    $(this).parent().siblings().find('.sub-menu').slideUp();
    $tgMenu.prev(".sub-menu").slideToggle();
});

// Menu Animation
$('.burger-menu, .tgCanvas-backdrop').on('click', function (e) {
    var $this = $(this);
    e.preventDefault();
    if ($('body').hasClass('menu-open')) {
        $this.removeClass('active');
        $('.tgCanvas-menu ul.navigation > li').each(function (i) {
            var that = $(this);
            setTimeout(function () {
                that.removeClass('is-show');
            }, i * 100);
        });
        setTimeout(function () {
            $('.side-menu-wrapper').removeClass('side-menu-show');
        }, 800);
        $('body').removeClass('menu-open');
    }
    else {
        $('.side-menu-wrapper').addClass('side-menu-show');
        $this.addClass('active');
        $('body').addClass('menu-open');
        setTimeout(function () {
            $('.tgCanvas-menu ul.navigation > li').each(function (i) {
                var that = $(this);
                setTimeout(function () {
                    that.addClass('is-show');
                }, i * 100);
            });
        }, 500);
    }
});


/*=============================================
	=    		Magnific Popup		      =
=============================================*/
$('.popup-image').magnificPopup({
	type: 'image',
	gallery: {
		enabled: true
	}
});
/* magnificPopup video view */
$('.popup-video').magnificPopup({
	type: 'iframe'
});


/*=============================================
	=           Parralax Active          =
=============================================*/
var image = document.getElementsByClassName("parralax-image");
new simpleParallax(image, {
    orientation: "right",
    scale: 1.15,
    delay: 0.4,
});


/*=============================================
	=    		 Wow Active  	         =
=============================================*/
function wowAnimation() {
	var wow = new WOW({
		boxClass: 'wow',
		animateClass: 'animated',
		offset: 0,
		mobile: false,
		live: true
	});
	wow.init();
}


})(jQuery);