<?php

include_once "values.php";

function copyTypeDeBien(SimpleXMLElement $BIEN, SimpleXMLElement $destBien): bool
{
    // All possible element names
    $candidates = [
        'AGRICOLE_VITICOLE','APPARTEMENT','CAVE','DEMEURE','FOND_COMMERCE',
        'FORET','GRANGE','IMMEUBLE','LOCAL_PROFESSIONNEL','MAISON','MARINA',
        'PARKING','PROGRAMME_NEUF','TERRAIN'
    ];

    // Find which candidate exists under $BIEN
    $typeNode = null;
    $typeName = null;

    foreach ($candidates as $name) {
        if (isset($BIEN->{$name})) {
            $typeNode = $BIEN->{$name};
            $typeName = $name;
            break;
        }
    }

    if (!$typeNode) {
        return false; // none of the types present
    }

    // Create wrapper <TYPE_DE_BIEN> and store the detected type name
    $typeEl = $destBien->addChild('TYPE_DE_BIEN');
    $typeEl->addChild('NOM', $typeName);

    // Copy all children of the found node into <TYPE_DE_BIEN>
    foreach ($typeNode->children() as $key => $value) {
        if ($key == "PICTOGRAMME")
            $typeEl->addChild("PICTOGRAMME", htmlspecialchars(getBordDescription((string)$value)));    
        else
            $typeEl->addChild($key, htmlspecialchars((string)$value));
    }

    return true;
}